import java.io.*;

public class Kopiuj {
  public static void main (String args[]) {
    if(args.length < 2){
      System.out.println("Wywołanie programu: Kopiuj plik_źródłowy plik_docelowy");
      return;
    }

    File sourceFile = new File(args[0]);
    File destFile = new File(args[1]);

    if(!sourceFile.exists()){
      System.out.println("Plik źródłowy nie istnieje.");
      return;
    }
    if(destFile.exists()){
      System.out.println("Plik docelowy istnieje.");
      return;
    }
    BufferedInputStream source = null;
    BufferedOutputStream dest = null;

    try{
      source = new BufferedInputStream(
        new FileInputStream(sourceFile)
      );
      dest = new BufferedOutputStream(
        new FileOutputStream(destFile)
      );
    }
    catch(FileNotFoundException e){
      System.out.println("Błąd podczas tworzenia strumieni: " + e);
      return;
    }

    int count = 0;
    int buffSize = 10000;
    byte[] buff = new byte[buffSize];

    try{
      while((count = source.read(buff)) != -1){
        dest.write(buff, 0, count);
      }
      source.close();
      dest.close();
    }
    catch(IOException e){
      System.out.print("\nBłąd wejścia-wyjścia podczas kopiowania pliku.");
      return;
    }
  }
}
